<?php
require_once('../app/BaseList.php');
require_once('../app/Parameter.php');
class ParameterList extends BaseList{
    public function add($params){
        if(isset($params['id'])){
            $this->id++;
        } else{
            $this->id++;
            $params['id']=$this->id;
        }
        $newObj=new Parameter($params);
        array_push($this->dataArray,$newObj);
    }
    public function exportAsArray(){
        $result=array(['name','units']);
        foreach($this->dataArray as $item){
            array_push($result,$item->getAsArray());
        }
        return $result;
    }
    public function exportAsXML(){
        $result='<?xml version="1.0" encoding="UTF-8"?><parameters>';
        foreach($this->dataArray as $item){
            $result.=$item->getAsXML();
        }
        $result.='</parameters>';
        return $result;
    }
    public function readFromFile(){
        $row=0;
        if (($handle = fopen("../data/parameters.csv", "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
              if($row>0){
                $dataArray=array('name'=>$data[0],'units'=>$data[1]);
                $this->add($dataArray);
              }
              $row++;
            }
            fclose($handle);
        }
    }
    public function saveToFile(){
        $fp = fopen('../data/parameters.csv', 'w');
        foreach ($this->exportAsArray() as $row) {
            fputcsv($fp, $row);
        }
        fclose($fp);
    }
    public function deleteFromDatabaseById($conn,$id){
        $stmt = $conn->prepare("DELETE from parameters WHERE id=?");
        $stmt->bind_param("s", $id);
        $stmt->execute();
        return true;
    }
    public function addToDatabase($conn,$params){
        $stmt = $conn->prepare("INSERT INTO `parameters` VALUES (DEFAULT,?,?)");
        $stmt->bind_param("ss", $name, $units);
        $units=$params['units'];
        $name=$params['name'];
        $stmt->execute();
        return true;
    }
    public function updateDatabaseRecord($conn,$params){
        $stmt = $conn->prepare("UPDATE `parameters` SET `name`=?,`units`=? WHERE id=?");
        $stmt->bind_param("sss", $name,$units,$id);
        $name=$params['name'];
        $units=$params['units'];
        $id=$params['id'];
        $stmt->execute();
        return true;
    }
    public function exportAsInputs($backpackParams){
        $result='';
        if(count($backpackParams)==0){
        foreach($this->dataArray as $item){
            $itemData=$item->getAsAssocArray();
            $result.='<p><input type="text" name="param'.$itemData['id'].'" placeholder="'.$itemData['name'].' ('.$itemData['units'].')"/></p>';
            }
        } else{
            foreach($this->dataArray as $item){
                $itemData=$item->getAsAssocArray();
            foreach($backpackParams as $bpitem){
                if($bpitem->parameter_id==$itemData['id']){
                    $result.='<p><input type="text" value ="'.$bpitem->value.'" name="param'.$itemData['id'].'" placeholder="'.$itemData['name'].' ('.$itemData['units'].')"/></p>';
                }
            }
            }

        }
        
        return $result;
    }
    public function getAllFromDatabase($conn){
        $sql = "SELECT * FROM parameters";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            $this->add($row);
        }
        }
    }
}