const categoryTableBody=document.querySelector('#categoriesTable tbody');
const parameterTableBody=document.querySelector('#parametersTable tbody');
const backpackTableBody=document.querySelector('#backpacksTable tbody');
const categoryForm=document.getElementById('categoryForm');
const parameterForm=document.getElementById('parameterForm');
const backpackForm=document.getElementById('backpackForm');
const categoryRow=document.getElementById('categoryRow');
const parameterRow=document.getElementById('parameterRow');
const backpackRow=document.getElementById('backpackRow');
const navMenu=document.getElementById('navMenu');
const loginForm=document.getElementById('loginForm');
const inputContainer=document.getElementById('backpackParametersInput');
const categoriesSelect=document.getElementById('categoriesSelect');
let categoryData={}
let parameterData={}
let backpackData={}
fetch('http://127.0.0.1/php-lab/api/profile')
    .then((response) => response.json())
    .then((data) => {
        if (data['login']){
            navMenu.style.display="flex";
            loginForm.style.display="none";
        }else{
            loginForm.style.display="block";
            navMenu.style.display="none";
            categoryRow.style.display="none";
            parameterRow.style.display="none";
            backpackRow.style.display="none";
        }   
    })
        .catch(console.error);
function displayCategories(){
    fetch('http://127.0.0.1/php-lab/api/categories')
    .then((response) => response.json())
    .then((data) => {
        categoryData=data;
        let content=``;
        let inputContent=``;
        for(i=0;i<data.length;i++){
            content+=`<tr>
            <td>`+data[i]['id']+`</td>
            <td>`+data[i]['name']+`</td>
            <td><a href="#" class="edit-category" data-id="`+data[i]['id']+`">Редагувати</a>
            <a href="#" class="delete-category" data-id="`+data[i]['id']+`">Видалити</a></td>        
            </tr>`
            inputContent+=`<option value="`+data[i]['id']+`">`+data[i]['name']+`</option>`
        }
        categoryTableBody.innerHTML=content;
        categoriesSelect.innerHTML=inputContent;      
    })
        .catch(console.error);
}
function displayParameters(){
    fetch('http://127.0.0.1/php-lab/api/parameters')
    .then((response) => response.json())
    .then((data) => {
        parameterData=data;
        let content=``;
        let inputContent=``;
        for(i=0;i<data.length;i++){
            content+=`<tr>
            <td>`+data[i]['id']+`</td>
            <td>`+data[i]['name']+`</td>
            <td>`+data[i]['units']+`</td>
            <td><a href="#" class="edit-parameter" data-id="`+data[i]['id']+`">Редагувати</a>
            <a href="#" class="delete-parameter" data-id="`+data[i]['id']+`">Видалити</a></td>        
            </tr>`;
            inputContent+=`<p><input type="text" class="bp-param-input" data-paramid="`+data[i]['id']+`" name="param`+data[i]['id']+`" placeholder="`+data[i]['name']+` (`+data[i]['units']+`)"/></p>`
        }
        parameterTableBody.innerHTML=content;
        inputContainer.innerHTML=inputContent;      
    })
        .catch(console.error);
}
function displayBackpacks(query){
    let url="http://127.0.0.1/php-lab/api/backpacks";
    if(query!==null){
        url="http://127.0.0.1/php-lab/api/backpacks?query="+query;
    }
    fetch(url)
    .then((response) => response.json())
    .then((data) => {
        backpackData=data;
        let content=``;
        for(i=0;i<data.length;i++){
            let parameterData=JSON.parse(data[i].parameters);
            let parameterContent=``;
            for (j=0;j<parameterData.length;j++){
                parameterContent+=parameterData[j]['name']+`: `+parameterData[j]['value']+'</br>';
            }
            content+=`<tr>
            <td>`+data[i]['id']+`</td>
            <td>`+data[i]['brand']+`</td>
            <td>`+data[i]['model']+`</td>
            <td>`+data[i]['price']+`</td>
            <td>`+data[i]['category']+`</td>
            <td>`+parameterContent+`</td>
            <td><a href="#" class="edit-backpack" data-id="`+data[i]['id']+`">Редагувати</a>
            <a href="#" class="delete-backpack" data-id="`+data[i]['id']+`">Видалити</a></td>        
            </tr>`
        }
        backpackTableBody.innerHTML=content;      
    })
        .catch(console.error);
}
displayCategories();
displayParameters()
displayBackpacks(null);
document.addEventListener('submit', function(e) {
    if(e.target.id=="categoryForm"){
        e.preventDefault();
        let formId=document.querySelector('#categoryForm input[name="itemid"]').value;
        let formName=document.querySelector('#categoryForm input[name="name"]').value;
        if(formId==""){
            let data=JSON.stringify({"name":formName});
            fetch("http://127.0.0.1/php-lab/api/categories",
                {
                    method: "POST",
                    headers: {
                        'Accept': 'application/json, text/plain, */*',
                        'Content-Type': 'application/json'
                    },
                    body: data
                })
            .then(function(res){ return res.json(); })
            .then(function(data){ 
                displayCategories();
                categoryForm.reset();
                document.querySelector('#categoryForm input[name="itemid"]').value="";
            });
        } else{
            let data=JSON.stringify({"id":formId,"name":formName});
            fetch("http://127.0.0.1/php-lab/api/categories",
                {
                    method: "PUT",
                    headers: {
                        'Accept': 'application/json, text/plain, */*',
                        'Content-Type': 'application/json'
                    },
                    body: data
                })
            .then(function(res){ return res.json(); })
            .then(function(data){ 
                displayCategories();
                categoryForm.reset();
                document.querySelector('#categoryForm input[name="itemid"]').value="";
            });
        }
        
    }
    if(e.target.id=="parameterForm"){
        e.preventDefault();
        let formId=document.querySelector('#parameterForm input[name="itemid"]').value;
        let formName=document.querySelector('#parameterForm input[name="name"]').value;
        let formUnits=document.querySelector('#parameterForm input[name="units"]').value;
        if(formId==""){
            let data=JSON.stringify({"name":formName,"units":formUnits});
            fetch("http://127.0.0.1/php-lab/api/parameters",
                {
                    method: "POST",
                    headers: {
                        'Accept': 'application/json, text/plain, */*',
                        'Content-Type': 'application/json'
                    },
                    body: data
                })
            .then(function(res){ return res.json(); })
            .then(function(data){ 
                displayParameters();
                parameterForm.reset();
                document.querySelector('#parameterForm input[name="itemid"]').value="";
            });
        } else{
            let data=JSON.stringify({"id":formId,"name":formName,"units":formUnits});
            fetch("http://127.0.0.1/php-lab/api/parameters",
                {
                    method: "PUT",
                    headers: {
                        'Accept': 'application/json, text/plain, */*',
                        'Content-Type': 'application/json'
                    },
                    body: data
                })
            .then(function(res){ return res.json(); })
            .then(function(data){ 
                displayParameters();
                parameterForm.reset();
                document.querySelector('#parameterForm input[name="itemid"]').value="";
            });
        }
        
    }
    if(e.target.id=="backpackForm"){
        e.preventDefault();
        let formId=document.querySelector('#backpackForm input[name="itemid"]').value;
        let formModel=document.querySelector('#backpackForm input[name="model"]').value;
        let formBrand=document.querySelector('#backpackForm input[name="brand"]').value;
        let formPrice=document.querySelector('#backpackForm input[name="price"]').value;
        let formCategory=document.querySelector('#backpackForm select[name="categoryid"]').value;
        //let formParameters=document.querySelector('#backpackForm input[name="parameters"]').value;
        if(formId==""){
            let data=
                {
                    "model":formModel,
                    "brand":formBrand,
                    "price":formPrice,
                    "categoryid":formCategory,
                };
            let paramInputs=document.querySelectorAll('.bp-param-input');
            for(i=0;i<paramInputs.length;i++){
                data['param'+paramInputs[i].getAttribute('data-paramid')]=paramInputs[i].value
            }
            fetch("http://127.0.0.1/php-lab/api/backpacks",
                {
                    method: "POST",
                    headers: {
                        'Accept': 'application/json, text/plain, */*',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                })
            .then(function(res){ return res.json(); })
            .then(function(data){ 
                displayBackpacks(null);
                backpackForm.reset();
                document.querySelector('#backpackForm input[name="itemid"]').value="";
            });
        } else{
            let data={
                    "id":formId,
                    "model":formModel,
                    "brand":formBrand,
                    "price":formPrice,
                    "categoryid":formCategory
                    };
            let paramInputs=document.querySelectorAll('.bp-param-input');
            for(i=0;i<paramInputs.length;i++){
                data['param'+paramInputs[i].getAttribute('data-paramid')]=paramInputs[i].value
            }        
            fetch("http://127.0.0.1/php-lab/api/backpacks",
                {
                    method: "PUT",
                    headers: {
                        'Accept': 'application/json, text/plain, */*',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                })
            .then(function(res){ return res.json(); })
            .then(function(data){ 
                displayBackpacks(null);
                backpackForm.reset();
                document.querySelector('#backpackForm input[name="itemid"]').value="";
            });
        }
        
    }
    if(e.target.id=="loginForm"){
        e.preventDefault();
        let formLogin=document.querySelector('#loginForm input[name="login"]').value;
        let formPass=document.querySelector('#loginForm input[name="password"]').value;
            let data=JSON.stringify({"login":formLogin,"password":formPass});
            fetch("http://127.0.0.1/php-lab/api/profile",
                {
                    method: "POST",
                    headers: {
                        'Accept': 'application/json, text/plain, */*',
                        'Content-Type': 'application/json'
                    },
                    body: data
                })
            .then(function(res){ return res.json(); })
            .then(function(data){ 
                if (data['login']){
                    navMenu.style.display="flex";
                    loginForm.style.display="none";
                }else{
                    loginForm.style.display="block";
                    navMenu.style.display="none";
                    categoryRow.style.display="none";
                    parameterRow.style.display="none";
                    backpackRow.style.display="none";
                }   
            });
        
    }
    if(e.target.id=="searchForm"){
        e.preventDefault();
        let formQuery=document.querySelector('#searchForm input[name="query"]').value;
        displayBackpacks(formQuery);
    }
  }, false);
  

document.addEventListener('click', function(e) {
    if(e.target.classList.contains('edit-category')){
        e.preventDefault();
        for(i=0;i<categoryData.length;i++){
            if(categoryData[i]['id']==e.target.getAttribute('data-id')){
                let itemData=categoryData[i];
                document.querySelector('#categoryForm input[name="itemid"]').value=itemData['id'];
                document.querySelector('#categoryForm input[name="name"]').value=itemData['name'];
            }
        }
    } else if(e.target.classList.contains('delete-category')){
        e.preventDefault();
        let data=JSON.stringify({"id":e.target.getAttribute('data-id')})
        fetch("http://127.0.0.1/php-lab/api/categories",
            {
                method: "DELETE",
                headers: {
                    'Accept': 'application/json, text/plain, */*',
                    'Content-Type': 'application/json'
                },
                body: data
            })
        .then(function(res){ return res.json(); })
        .then(function(data){ 
            displayCategories();
        });
    } else if(e.target.classList.contains('edit-parameter')){
        e.preventDefault();
        for(i=0;i<parameterData.length;i++){
            if(parameterData[i]['id']==e.target.getAttribute('data-id')){
                let itemData=parameterData[i];
                document.querySelector('#parameterForm input[name="itemid"]').value=itemData['id'];
                document.querySelector('#parameterForm input[name="name"]').value=itemData['name'];
                document.querySelector('#parameterForm input[name="units"]').value=itemData['units'];
            }
        }
    } else if(e.target.classList.contains('delete-parameter')){
        e.preventDefault();
        let data=JSON.stringify({"id":e.target.getAttribute('data-id')})
        fetch("http://127.0.0.1/php-lab/api/parameters",
            {
                method: "DELETE",
                headers: {
                    'Accept': 'application/json, text/plain, */*',
                    'Content-Type': 'application/json'
                },
                body: data
            })
        .then(function(res){ return res.json(); })
        .then(function(data){ 
            displayParameters();
        });
    }else if(e.target.classList.contains('edit-backpack')){
        e.preventDefault();
        for(i=0;i<backpackData.length;i++){
            if(backpackData[i]['id']==e.target.getAttribute('data-id')){
                let itemData=backpackData[i];
                document.querySelector('#backpackForm input[name="itemid"]').value=itemData['id'];
                document.querySelector('#backpackForm input[name="model"]').value=itemData['model'];
                document.querySelector('#backpackForm input[name="brand"]').value=itemData['brand'];
                document.querySelector('#backpackForm input[name="price"]').value=itemData['price'];
                
                bpParamData=JSON.parse(itemData['parameters']);
                //document.querySelector('#backpackForm input[name="parameters"]').value=itemData['parameters'];
                
                for(i=0;i<bpParamData.length;i++){
                    document.querySelector('.bp-param-input[data-paramid="'+bpParamData[i].parameter_id+'"]').value=bpParamData[i].value;
                }
            }
        }
    } else if(e.target.classList.contains('delete-backpack')){
        e.preventDefault();
        let data=JSON.stringify({"id":e.target.getAttribute('data-id')})
        fetch("http://127.0.0.1/php-lab/api/backpacks",
            {
                method: "DELETE",
                headers: {
                    'Accept': 'application/json, text/plain, */*',
                    'Content-Type': 'application/json'
                },
                body: data
            })
        .then(function(res){ return res.json(); })
        .then(function(data){ 
            displayBackpacks(null);
        });
    } else if(e.target.id=="categoriesButton"){
        e.preventDefault();
        categoryRow.style.display="flex";
        parameterRow.style.display="none";
        backpackRow.style.display="none";
    } else if(e.target.id=="parametersButton"){
        e.preventDefault();
        categoryRow.style.display="none";
        parameterRow.style.display="flex";
        backpackRow.style.display="none";
    } else if(e.target.id=="backpacksButton"){
        e.preventDefault();
        categoryRow.style.display="none";
        parameterRow.style.display="none";
        backpackRow.style.display="flex";
    }else if(e.target.id=="logoutButton"){
        e.preventDefault();
        fetch("http://127.0.0.1/php-lab/api/profile?action=logout",
            )
        .then(function(res){ return res.json(); })
        .then(function(data){ 
                loginForm.style.display="block";
                navMenu.style.display="none";
                categoryRow.style.display="none";
                parameterRow.style.display="none";
                backpackRow.style.display="none"; 
        });
    }
  }, false);